/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.compat.IPModInfoChecking;
import qouteall.imm_ptl.core.compat.iris_compatibility.ExperimentalIrisPortalRenderer;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisCompatibilityPortalRenderer;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisPortalRenderer;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.PortalGroup;
import qouteall.imm_ptl.core.render.PortalRenderable;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

public abstract class PortalRenderer {
    public static final Minecraft client = Minecraft.m_91087_();
    private static boolean fabulousWarned = false;

    public abstract void onBeforeTranslucentRendering(PoseStack var1);

    public abstract void onAfterTranslucentRendering(PoseStack var1);

    public abstract void onHandRenderingEnded(PoseStack var1);

    public void onBeforeHandRendering(PoseStack matrixStack) {
    }

    public abstract void prepareRendering();

    public abstract void finishRendering();

    public abstract void renderPortalInEntityRenderer(Portal var1);

    public abstract boolean replaceFrameBufferClearing();

    protected List<PortalRenderable> getPortalsToRender(PoseStack matrixStack) {
        Supplier<Frustum> frustumSupplier = Helper.cached(() -> {
            Frustum frustum = new Frustum(matrixStack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix());
            Vec3 cameraPos = PortalRenderer.client.f_91063_.m_109153_().m_90583_();
            frustum.m_113002_(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_);
            return frustum;
        });
        ObjectArrayList renderables = new ObjectArrayList();
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals((Level)PortalRenderer.client.f_91073_);
        for (Portal globalPortal : globalPortals) {
            if (PortalRenderer.shouldSkipRenderingPortal(globalPortal, frustumSupplier)) continue;
            renderables.add((Object)globalPortal);
        }
        Object2ObjectOpenHashMap groupToRenderable = new Object2ObjectOpenHashMap();
        PortalRenderer.client.f_91073_.m_104735_().forEach(e -> {
            Portal portal;
            if (e instanceof Portal && !PortalRenderer.shouldSkipRenderingPortal(portal = (Portal)e, frustumSupplier)) {
                PortalLike renderingDelegate = portal.getRenderingDelegate();
                if (renderingDelegate instanceof PortalGroup) {
                    PortalGroup portalGroup = (PortalGroup)renderingDelegate;
                    if (groupToRenderable.containsKey((Object)portalGroup)) {
                        ((PortalGroupToRender)groupToRenderable.get((Object)portalGroup)).portals.add(portal);
                    } else {
                        PortalGroupToRender renderable = new PortalGroupToRender(portalGroup, Lists.newArrayList((Object[])new Portal[]{portal}));
                        groupToRenderable.put((Object)portalGroup, (Object)renderable);
                        renderables.add((Object)renderable);
                    }
                } else {
                    renderables.add((Object)portal);
                }
            }
        });
        Vec3 cameraPos = CHelper.getCurrentCameraPos();
        renderables.sort(Comparator.comparingDouble(e -> e.getPortalLike().getDistanceToNearestPointInPortal(cameraPos)));
        return renderables;
    }

    private static boolean shouldSkipRenderingPortal(Portal portal, Supplier<Frustum> frustumSupplier) {
        Frustum frustum;
        PortalLike outerPortal;
        if (!portal.isPortalValid()) {
            return true;
        }
        if (!portal.isVisible() && IPGlobal.maxPortalLayer != 0) {
            return true;
        }
        if (RenderStates.getRenderedPortalNum() >= IPGlobal.portalRenderLimit) {
            return true;
        }
        Vec3 cameraPos = TransformationManager.getIsometricAdjustedCameraPos();
        if (!portal.isRoughlyVisibleTo(cameraPos)) {
            return true;
        }
        if (PortalRendering.isRendering() && (outerPortal = PortalRendering.getRenderingPortal()).cannotRenderInMe(portal)) {
            return true;
        }
        double distance = portal.getDistanceToNearestPointInPortal(cameraPos);
        if (distance > PortalRenderer.getRenderRange()) {
            return true;
        }
        if (IPCGlobal.earlyFrustumCullingPortal && distance > 0.03 && !(frustum = frustumSupplier.get()).m_113029_(portal.getExactAreaBox())) {
            return true;
        }
        boolean predicateTest = MinecraftForge.EVENT_BUS.post((Event)new DoRenderPortalEvent(portal));
        return predicateTest;
    }

    public static double getRenderRange() {
        double outerPortalScale;
        double range = PortalRenderer.client.f_91066_.m_193772_() * 16;
        if (RenderStates.isLaggy || IPGlobal.reducedPortalRendering) {
            range = 16.0;
        }
        if (PortalRendering.getPortalLayer() > 1) {
            range /= (double)PortalRendering.getPortalLayer();
        }
        if (PortalRendering.getPortalLayer() >= 1 && (outerPortalScale = PortalRendering.getRenderingPortal().getScale()) > 2.0) {
            range *= outerPortalScale;
            range = Math.min(range, 512.0);
        }
        return range;
    }

    protected final void renderPortalContent(PortalRenderable portalRenderable) {
        PortalLike portalLike = portalRenderable.getPortalLike();
        if (PortalRendering.getPortalLayer() > PortalRendering.getMaxPortalLayer()) {
            return;
        }
        ClientLevel newWorld = ClientWorldLoader.getWorld(portalLike.getDestDim());
        PortalRendering.onBeginPortalWorldRendering();
        int renderDistance = PortalRenderer.getPortalRenderDistance(portalLike);
        this.invokeWorldRendering(new WorldRenderInfo.Builder().setWorld(newWorld).setCameraPos(PortalRendering.getRenderingCameraPos()).setCameraTransformation(portalLike.getAdditionalCameraTransformation()).setOverwriteCameraTransformation(false).setDescription(portalLike.getDiscriminator()).setRenderDistance(renderDistance).setDoRenderHand(false).setEnableViewBobbing(true).setDoRenderSky(!portalLike.isFuseView()).build());
        PortalRendering.onEndPortalWorldRendering();
        GlStateManager._enableDepthTest();
        MyRenderHelper.restoreViewPort();
    }

    private static int getPortalRenderDistance(PortalLike portal) {
        int mcRenderDistance = PortalRenderer.client.f_91066_.m_193772_();
        if (portal.getScale() > 2.0) {
            double radiusBlocks = portal.getDestAreaRadiusEstimation() * 1.4;
            radiusBlocks = Math.min(radiusBlocks, 512.0);
            return Math.max((int)(radiusBlocks / 16.0), mcRenderDistance);
        }
        if (IPGlobal.reducedPortalRendering) {
            return mcRenderDistance / 3;
        }
        return mcRenderDistance;
    }

    public void invokeWorldRendering(WorldRenderInfo worldRenderInfo) {
        MyGameRenderer.renderWorldNew(worldRenderInfo, Runnable::run);
    }

    @Nullable
    public static Matrix4f getPortalTransformation(Portal portal) {
        Matrix4f rot = PortalRenderer.getPortalRotationMatrix(portal);
        Matrix4f mirror = portal instanceof Mirror ? TransformationManager.getMirrorTransformation(portal.getNormal()) : null;
        Matrix4f scale = PortalRenderer.getPortalScaleMatrix(portal);
        return PortalRenderer.combineNullable(rot, PortalRenderer.combineNullable(mirror, scale));
    }

    @Nullable
    public static Matrix4f getPortalRotationMatrix(Portal portal) {
        if (portal.getRotation() == null) {
            return null;
        }
        Quaternionf rot = portal.getRotation().toMcQuaternion();
        rot.conjugate();
        return rot.get(new Matrix4f());
    }

    @Nullable
    public static Matrix4f combineNullable(@Nullable Matrix4f a, @Nullable Matrix4f b) {
        return Helper.combineNullable(a, b, (m1, m2) -> {
            m1.mul((Matrix4fc)m2);
            return m1;
        });
    }

    @Nullable
    public static Matrix4f getPortalScaleMatrix(Portal portal) {
        if (PortalRenderer.shouldApplyScaleToModelView(portal)) {
            float v = (float)(1.0 / portal.getScale());
            return new Matrix4f().scale(v, v, v);
        }
        return null;
    }

    public static boolean shouldApplyScaleToModelView(PortalLike portal) {
        return portal.hasScaling() && portal.isFuseView();
    }

    public void onBeginIrisTranslucentRendering(PoseStack matrixStack) {
    }

    public static void switchToCorrectRenderer() {
        if (PortalRendering.isRendering()) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.m_232060_().m_231551_() == GraphicsStatus.FABULOUS && !fabulousWarned) {
            fabulousWarned = true;
            CHelper.printChat((Component)Component.m_237115_((String)"imm_ptl.fabulous_warning"));
        }
        IPModInfoChecking.checkShaderpack();
        if (IrisInterface.invoker.isIrisPresent() && IrisInterface.invoker.isShaders()) {
            if (IPCGlobal.experimentalIrisPortalRenderer) {
                PortalRenderer.switchRenderer(ExperimentalIrisPortalRenderer.instance);
                return;
            }
            switch (IPGlobal.renderMode) {
                case normal: {
                    PortalRenderer.switchRenderer(IrisPortalRenderer.instance);
                    break;
                }
                case compatibility: {
                    PortalRenderer.switchRenderer(IrisCompatibilityPortalRenderer.instance);
                    break;
                }
                case debug: {
                    PortalRenderer.switchRenderer(IrisCompatibilityPortalRenderer.debugModeInstance);
                    break;
                }
                case none: {
                    PortalRenderer.switchRenderer(IPCGlobal.rendererDummy);
                }
            }
            return;
        }
        switch (IPGlobal.renderMode) {
            case normal: {
                PortalRenderer.switchRenderer(IPCGlobal.rendererUsingStencil);
                break;
            }
            case compatibility: {
                PortalRenderer.switchRenderer(IPCGlobal.rendererUsingFrameBuffer);
                break;
            }
            case debug: {
                PortalRenderer.switchRenderer(IPCGlobal.rendererDebug);
                break;
            }
            case none: {
                PortalRenderer.switchRenderer(IPCGlobal.rendererDummy);
            }
        }
    }

    private static void switchRenderer(PortalRenderer renderer) {
        if (IPCGlobal.renderer != renderer) {
            Helper.log("switched to renderer " + String.valueOf(renderer.getClass()));
            IPCGlobal.renderer = renderer;
            if (IrisInterface.invoker.isShaders()) {
                IrisInterface.invoker.reloadPipelines();
            }
        }
    }

    @Cancelable
    public static final class DoRenderPortalEvent
    extends Event {
        public final Portal portal;

        public DoRenderPortalEvent(Portal portal) {
            this.portal = portal;
        }
    }

    public record PortalGroupToRender(PortalGroup group, List<Portal> portals) implements PortalRenderable
    {
        @Override
        public PortalLike getPortalLike() {
            return this.group;
        }
    }
}

